function FirstAssistant() {
	/* this is the creator function for your scene assistant object. It will be passed all the 
	   additional parameters (after the scene name) that were passed to pushScene. The reference
	   to the scene controller (this.controller) has not be established yet, so any initialization
	   that needs the scene controller should be done in the setup function below. */

	   
	   }
	   
FirstAssistant.prototype.handleButtonPress = function(event){
// set a variable to the value of the textbox
this.amount=Number(this.amountModel.value); //This also converts the text to a number

// increment the total and update the display
    this.total = this.total + this.amount;
    this.controller.get('count').update(this.total);
	Mojo.Log.info("The user tapped Add and now the count is:" + this.total);
}

FirstAssistant.prototype.handleA = function(event){
// set a variable to the value of the textbox
this.amount=Number(this.amountModel.value); //This also converts the text to a number

// subtract the total and update the display
    this.total = this.total - this.amount;
	this.controller.get('count').update(this.total);
}

FirstAssistant.prototype.handleC = function(event){

// clear the total and update the display
   
   this.total=0;
   this.controller.get('count').update(this.total);
}

FirstAssistant.prototype.handleCommand = function(event) {
	if(event.type == Mojo.Event.command) {
		switch(event.command)
		{
			case 'openCalculator':
				this.controller.serviceRequest('palm://com.palm.applicationManager', {
				method:'launch',
				parameters: {
				    id: 'com.palm.app.calculator',
					}
				});
				break;

			case 'openEmail':
				this.controller.serviceRequest('palm://com.palm.applicationManager', {
				method:'launch',
                parameters:  {
                    id: 'com.palm.app.email',
                    params: {
                        summary: 'Add/Subtract Count',
                        text: 'The count is: ' + this.total,
						}
					}
				});
				break;
		}
	}
}	

FirstAssistant.prototype.setup = function() {
	/* this function is for setup tasks that have to happen when the scene is first created */
	/* use Mojo.View.render to render view templates and add them to the scene, if needed. */
	/* setup widgets here */
	/* add event handlers to listen to events from widgets */

//Read theme cookie or default info
	AddSubcookie = new Mojo.Model.Cookie('addSub'); //Looks for a cookie called 'addSub'
	    this.oldThemePrefs = AddSubcookie.get(); //Read the cookie
		if(this.oldThemePrefs) //If the cookie data exists, read it
                {
                this.theme = this.oldThemePrefs.theme;
                }
        else
                {
            //In this case, the cookie doesn't exist
                this.theme = "DEFAULT_THEME";		
                }	
		
//Setup Theme
	if (this.theme == "DEFAULT_THEME"){
		$$('body')[0].addClassName('palm-default');
		$$('body')[0].removeClassName('palm-dark');
	}else{
		$$('body')[0].addClassName('palm-dark');
		$$('body')[0].removeClassName('palm-default');
	}	
	
//Set up Command Menu
	this.cmdMenuModel = {
	visible: true,
	items: [
		{items:
			[
				{label: $L('Email'), command:'openEmail', shortcut: 'e'},
//				{label: $L('Email'), icon:'stop', command:'openEmail'},
//				{label: $L('Email'), icon:'forward', command:'openEmail'},
//				{label: $L('Email'), icon:'refresh', command:'openEmail'},
//				{label: $L('Email'), icon:'search', command:'openEmail'},
//				{label: $L('Email'), icon:'new', command:'openEmail'},
//				{label: $L('Email'), icon:'attach', command:'openEmail'},
//				{label: $L('Email'), icon:'compose', command:'openEmail'}, //This is probably the most appropriate for this application
//				{label: $L('Email'), icon:'conversation', command:'openEmail'},
//				{label: $L('Email'), icon:'delete', command:'openEmail'},
//				{label: $L('Email'), icon:'file', command:'openEmail'},
//				{label: $L('Email'), icon:'forward-email', command:'openEmail'}, //Or, maybe this one
//				{label: $L('Email'), icon:'info', command:'openEmail'},
//				{label: $L('Email'), icon:'priority', command:'openEmail'},
//				{label: $L('Email'), icon:'reply-all', command:'openEmail'},
//				{label: $L('Email'), icon:'reply', command:'openEmail'},
//				{label: $L('Email'), icon:'save', command:'openEmail'},
//				{label: $L('Email'), icon:'send', command:'openEmail'},		//Possibly even this one		
//				{label: $L('Email'), icon:'sync', command:'openEmail'},	
//				{label: $L('Email'), icon:'edit-profile', command:'openEmail'},
//				{label: $L('Email'), icon:'make-vip', command:'openEmail'},	
//				{label: $L('Email'), icon:'new-contact', command:'openEmail'},	
//				{label: $L('Email'), icon:'remove-vip', command:'openEmail'},	
//				{label: $L('Email'), icon:'down', command:'openEmail'},					
			]},
		{},
		{items:
			[
				{label: $L('Calculator'), command:'openCalculator', shortcut: 'k'},
			]}
	],
	};

attrib = {
    menuClass: 'no-fade' //This removes the 'fade' effect so the palm-dark theme looks good with command buttons
}	
	
this.controller.setupWidget(Mojo.Menu.commandMenu, attrib, this.cmdMenuModel);	
	
	// set the initial total and display it
    this.total=0;
    this.controller.get('count').update(this.total);

// Setup Application Menu
this.controller.setupWidget(Mojo.Menu.appMenu, AddSubMenuAttr, AddSubMenuModel);	

//Setup Textfield to be numbers only
	this.controller.setupWidget(
      "mainTextField",
      {//Attributes
		 maxLength: 1, //sets a maximum number of characters to 1
		 modifierState: Mojo.Widget.numLock, //Turns on the numLock for the text field
		 focusMode: Mojo.Widget.focusSelectMode, //If the text box is selected, all of the characters are highlighted
         charsAllow: function( charCode ) {

            return( ( charCode >= 48 && charCode <= 57) ); //uses ASCII codes to only allow 1 - 9
 }
      },
      this.amountModel = {
         value: ""
      }
   );
   
// a local object for button attributes
    this.buttonAttributes = {};

// a local object for button model
    this.buttonModel = {
        buttonLabel : 'Add',
        buttonClass : 'affirmative',
        disabled : false
        };
		
// set up the button
    this.controller.setupWidget("MyButton", this.buttonAttributes, this.buttonModel);
	
	this.controller.setupWidget("ButtonSubtract", this.buttonAttributes, this.Model = {buttonLabel : 'Subtract', buttonClass : 'negative', disabled : false});
	
	this.controller.setupWidget("ButtonClear", this.buttonAttributes, this.Model = {buttonLabel : 'Clear', buttonClass : '', disabled : false});
// bind the button to its handler
    Mojo.Event.listen(this.controller.get('MyButton'), Mojo.Event.tap, this.handleButtonPress.bind(this));

	//Bind event handler for Subract button
	Mojo.Event.listen(this.controller.get('ButtonSubtract'), Mojo.Event.tap,this.handleA.bind(this));
	
	//Bind event handler for Clear button
	Mojo.Event.listen(this.controller.get('ButtonClear'), Mojo.Event.tap,this.handleC.bind(this));

}

FirstAssistant.prototype.activate = function(event) {
	/* put in event handlers here that should only be in effect when this scene is active. For
	   example, key handlers that are observing the document */
}


FirstAssistant.prototype.deactivate = function(event) {
	/* remove any event handlers you added in activate and do any other cleanup that should happen before
	   this scene is popped or another scene is pushed on top */
}

FirstAssistant.prototype.cleanup = function(event) {
	/* this function should do any cleanup needed before the scene is destroyed as 
	   a result of being popped off the scene stack */
	  this.controller.stopListening(this.controller.get('MyButton'), Mojo.Event.tap, this.handleButtonPress.bind(this));
      //Cleanup Subtraction button	  
	  this.controller.stopListening(this.controller.get('ButtonSubtract'),Mojo.Event.tap,this.handleA.bind(this));
	  
	  //Cleanup Clear button	  
	  this.controller.stopListening(this.controller.get('ButtonClear'),Mojo.Event.tap,this.handleC.bind(this));
}
