function PreferencesAssistant() {
	/* this is the creator function for your scene assistant object. It will be passed all the 
	   additional parameters (after the scene name) that were passed to pushScene. The reference
	   to the scene controller (this.controller) has not be established yet, so any initialization
	   that needs the scene controller should be done in the setup function below. */
}
PreferencesAssistant.prototype.handleThemeChange = function(event){
//This function changes the theme, based on what was selected from the List Selector
this.theme = this.themeModel.value;
	if (this.theme == "DEFAULT_THEME"){
		$$('body')[0].addClassName('palm-default');
		$$('body')[0].removeClassName('palm-dark');
	}else{
		$$('body')[0].addClassName('palm-dark');
		$$('body')[0].removeClassName('palm-default');
	}
}

PreferencesAssistant.prototype.setup = function() {
	/* this function is for setup tasks that have to happen when the scene is first created */
	/* use Mojo.View.render to render view templates and add them to the scene, if needed */
	/* setup widgets here */
	/* add event handlers to listen to events from widgets */

//Read theme cookie or default info
	AddSubcookie = new Mojo.Model.Cookie('addSub'); //Looks for a cookie called 'addSub'
	    this.oldThemePrefs = AddSubcookie.get(); //Read the cookie
		if(this.oldThemePrefs) //If the cookie data exists, read it
                {
                this.theme = this.oldThemePrefs.theme;
                }
        else
                {
            //In this case, the cookie doesn't exist
                this.theme = "DEFAULT_THEME";		
                }	

	
        //Setup ListSelector
	this.themeAttributes = {
			label: $L('Theme'),
            choices: [
                {label: "Default", value: "DEFAULT_THEME"},
                {label: "Dark", value: "DARK_THEME"}
                ]};
	this.themeModel = {
	        value: $L(this.theme),                
	        disabled: false
	        };
	this.controller.setupWidget("themeListId", this.themeAttributes, this.themeModel);
	
	/* add event handlers to listen to events from widgets */
	this.themeChanged = this.handleThemeChange.bindAsEventListener(this);
	Mojo.Event.listen(this.controller.get('themeListId'), Mojo.Event.propertyChange, this.themeChanged.bind(this));        
        
};

PreferencesAssistant.prototype.activate = function(event) {
	/* put in event handlers here that should only be in effect when this scene is active. For
	   example, key handlers that are observing the document */
};

PreferencesAssistant.prototype.deactivate = function(event) {
	/* remove any event handlers you added in activate and do any other cleanup that should happen before
	   this scene is popped or another scene is pushed on top */
	//When the scene is deactivated, write the theme information to the cookie   
	AddSubcookie = new Mojo.Model.Cookie('addSub');
        	dataField = this.themeModel.value;
                AddSubcookie.put({
		theme:dataField,
	});
};

PreferencesAssistant.prototype.cleanup = function(event) {
	/* this function should do any cleanup needed before the scene is destroyed as 
	   a result of being popped off the scene stack */

//Clean up ListSelector - IMPORTANT!
	Mojo.Event.stopListening(this.controller.get('themeListId'), Mojo.Event.propertyChange, this.themeChanged.bind(this));
     
};
